/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.sfp.surveillance;

import com.ibm.hsc.common.util.Trace;
import com.ibm.hsc.sfp.surveillance.Surveillance;
import com.ibm.hsc.sfp.surveillance.SurveillanceEvent;
import com.ibm.hsc.sfp.surveillance.SurveillanceEventType;
import com.ibm.hsc.sfp.surveillance.SurveillancePartitionStateList;
import com.ibm.hsc.sfp.surveillance.SurveillanceTimerThread;
import com.ibm.hsc.sfp.surveillance.SurveillanceTimerThreadState;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.Vector;
import org.snia.wbem.cim.UnsignedInt8;

public class SurveillanceEventList {
    private static final String TRACE_MASKD = "JSURVLSD";
    private static final String TRACE_MASKF = "JSURVLSF";
    private static final String TRACE_MASKT = "JSURVLST";
    private TreeMap events = new TreeMap();
    private SurveillancePartitionStateList partitionStates = null;
    private SurveillanceTimerThread timerThread = null;
    private Surveillance surveillance = null;

    SurveillanceEventList(Surveillance surveillance, SurveillancePartitionStateList surveillancePartitionStateList) {
        if (3 <= Trace.LEVEL) {
            this.doDebug("events are now (due to constructor): ");
        }
        this.timerThread = new SurveillanceTimerThread(this, surveillancePartitionStateList, surveillance);
        this.partitionStates = surveillancePartitionStateList;
        this.surveillance = surveillance;
    }

    public static void main(String[] stringArray) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void add(SurveillanceEvent surveillanceEvent, long l) {
        boolean bl = false;
        Date date = null;
        SurveillanceEventType surveillanceEventType = null;
        boolean bl2 = false;
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "-> add(" + surveillanceEvent + ", " + l + ")");
        }
        if ((surveillanceEventType = this.partitionStates.getLastEventType(surveillanceEvent.getCECMTM(), surveillanceEvent.getCECMS(), surveillanceEvent.getPartitionId(), surveillanceEvent.getAdapter())) == null || !surveillanceEventType.equals(surveillanceEvent.getType())) {
            if (surveillanceEvent.getType() != SurveillanceEventType.NOT_YET_CONNECTED) {
                this.partitionStates.setLastEventType(surveillanceEvent.getCECMTM(), surveillanceEvent.getCECMS(), surveillanceEvent.getPartitionId(), surveillanceEvent.getType(), surveillanceEvent.getAdapter());
            }
            SurveillanceEventList surveillanceEventList = this;
            synchronized (surveillanceEventList) {
                if (3 <= Trace.LEVEL) {
                    Trace.trace(TRACE_MASKD, "deleting any pending events as appropriate");
                }
                if (surveillanceEvent.getType().equals(SurveillanceEventType.CONNECT)) {
                    this.delete(surveillanceEvent.getCECMTM(), surveillanceEvent.getCECMS(), surveillanceEvent.getPartitionId(), SurveillanceEventType.DISCONNECT, surveillanceEvent.getAdapter());
                } else if (surveillanceEvent.getType().equals(SurveillanceEventType.DISCONNECT)) {
                    this.delete(surveillanceEvent.getCECMTM(), surveillanceEvent.getCECMS(), surveillanceEvent.getPartitionId(), SurveillanceEventType.CONNECT, surveillanceEvent.getAdapter());
                }
                surveillanceEvent.setPartitionCIMState(this.partitionStates.getCIMState(surveillanceEvent.getCECMTM(), surveillanceEvent.getCECMS(), surveillanceEvent.getPartitionId()));
                if (3 <= Trace.LEVEL) {
                    Trace.trace(TRACE_MASKD, "adding the event");
                }
                date = new Date(surveillanceEvent.getTimeOfEvent().getTime() + l);
                bl = this.addTimeAndEvent(this.events, date, surveillanceEvent);
                if (3 <= Trace.LEVEL) {
                    this.doDebug("events are now: ");
                }
                SurveillanceTimerThread surveillanceTimerThread = this.timerThread;
                synchronized (surveillanceTimerThread) {
                    if (this.timerThread.getState().equals(SurveillanceTimerThreadState.NOT_RUNNING)) {
                        new Thread(this.timerThread).start();
                        this.timerThread.setState(SurveillanceTimerThreadState.RUNNING);
                    } else if (bl && this.events.firstKey() == date) {
                        this.timerThread.wakeup();
                    }
                }
            }
        }
        if (2 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKF, "duplicate event discarded : " + surveillanceEvent);
        }
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "<- add(...)");
        }
    }

    synchronized void addIfNotAlready(SurveillanceEvent surveillanceEvent, long l) {
        SurveillanceEvent surveillanceEvent2 = null;
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "-> addIfNotAlready(" + surveillanceEvent + ", " + l + ")");
        }
        if ((surveillanceEvent2 = this.getEvent(surveillanceEvent.getCECMTM(), surveillanceEvent.getCECMS(), surveillanceEvent.getPartitionId(), surveillanceEvent.getType(), surveillanceEvent.getAdapter())) == null) {
            this.add(surveillanceEvent, l);
        }
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "<- addIfNotAlready(...)");
        }
    }

    private synchronized SurveillanceEvent getEvent(String string, String string2, String string3, SurveillanceEventType surveillanceEventType, String string4) {
        SurveillanceEvent surveillanceEvent = null;
        Vector vector = null;
        Map.Entry entry = null;
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "-> getEvent(" + string + ", " + string2 + ", " + string3 + ", " + surveillanceEventType + ", " + string4 + ")");
        }
        Iterator iterator = this.events.entrySet().iterator();
        while (iterator.hasNext()) {
            entry = iterator.next();
            vector = (Vector)entry.getValue();
            Iterator iterator2 = vector.iterator();
            while (iterator2.hasNext()) {
                surveillanceEvent = (SurveillanceEvent)iterator2.next();
                if (!surveillanceEvent.getPartitionId().equals(string3) || !surveillanceEvent.getType().equals(surveillanceEventType) || !surveillanceEvent.getCECMTM().equals(string) || !surveillanceEvent.getCECMS().equals(string2) || !(string4 == null ? surveillanceEvent.getAdapter() == null : string4.equals(surveillanceEvent.getAdapter()))) continue;
                if (1 <= Trace.LEVEL) {
                    Trace.trace(TRACE_MASKT, "<- getEvent(...) returning " + surveillanceEvent);
                }
                return surveillanceEvent;
            }
        }
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "<- getEvent(...) returning null");
        }
        return null;
    }

    private synchronized boolean addTimeAndEvent(TreeMap treeMap, Date date, SurveillanceEvent surveillanceEvent) {
        Vector<SurveillanceEvent> vector = null;
        boolean bl = true;
        vector = (Vector<SurveillanceEvent>)treeMap.get(date);
        if (vector == null) {
            vector = new Vector<SurveillanceEvent>();
            vector.add(surveillanceEvent);
            treeMap.put(date, vector);
        } else {
            vector.add(surveillanceEvent);
            bl = false;
        }
        return bl;
    }

    synchronized void delete(String string, String string2, String string3, SurveillanceEventType surveillanceEventType, String string4) {
        SurveillanceEvent surveillanceEvent = null;
        Vector vector = null;
        Map.Entry entry = null;
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "-> delete(" + string + ", " + string2 + ", " + string3 + ", " + surveillanceEventType + ", " + string4 + ")");
        }
        Iterator iterator = this.events.entrySet().iterator();
        while (iterator.hasNext()) {
            entry = iterator.next();
            vector = (Vector)entry.getValue();
            Iterator iterator2 = vector.iterator();
            while (iterator2.hasNext()) {
                surveillanceEvent = (SurveillanceEvent)iterator2.next();
                if (!surveillanceEvent.getPartitionId().equals(string3) || !surveillanceEvent.getType().equals(surveillanceEventType) || !surveillanceEvent.getCECMTM().equals(string) || !surveillanceEvent.getCECMS().equals(string2) || !(string4 == null ? surveillanceEvent.getAdapter() == null : string4.equals(surveillanceEvent.getAdapter()))) continue;
                iterator.remove();
                if (3 > Trace.LEVEL) continue;
                this.doDebug("events are now : ");
            }
        }
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "<- delete(...)");
        }
    }

    synchronized void deleteAll() {
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "-> deleteAll()");
        }
        this.events = new TreeMap();
        if (3 <= Trace.LEVEL) {
            this.doDebug("events are now (due to deleteall): ");
        }
        this.timerThread.wakeup();
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "<- deleteAll()");
        }
    }

    synchronized void change(SurveillanceEventType surveillanceEventType, long l) {
        Object var4_3 = null;
        Map.Entry entry = null;
        Date date = null;
        Vector vector = null;
        SurveillanceEvent surveillanceEvent = null;
        TreeMap treeMap = null;
        boolean bl = false;
        Date date2 = null;
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "-> change(" + surveillanceEventType + ", " + l + ")");
        }
        treeMap = new TreeMap();
        bl = false;
        Iterator iterator = this.events.entrySet().iterator();
        while (iterator.hasNext()) {
            entry = iterator.next();
            date = (Date)entry.getKey();
            vector = (Vector)entry.getValue();
            Iterator iterator2 = vector.iterator();
            while (iterator2.hasNext()) {
                surveillanceEvent = (SurveillanceEvent)iterator2.next();
                if (surveillanceEvent.getType().equals(surveillanceEventType)) {
                    date2 = new Date(surveillanceEvent.getTimeOfEvent().getTime() + l);
                    bl = true;
                } else {
                    date2 = date;
                }
                this.addTimeAndEvent(treeMap, date2, surveillanceEvent);
            }
        }
        if (bl) {
            if (3 <= Trace.LEVEL) {
                Trace.trace(TRACE_MASKD, "The changed event and partition state list is being changed from " + this.events + " to " + treeMap);
            }
            this.events = treeMap;
            this.timerThread.wakeup();
        }
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "<- change(...)");
        }
    }

    Surveillance getSurveillance() {
        return this.surveillance;
    }

    synchronized Object firstKey() {
        if (this.events != null) {
            return this.events.firstKey();
        }
        return null;
    }

    synchronized Set keySet() {
        if (this.events != null) {
            return this.events.keySet();
        }
        return null;
    }

    synchronized Object get(Object object) {
        if (this.events != null) {
            return this.events.get(object);
        }
        return null;
    }

    synchronized boolean isEmpty() {
        if (this.events != null) {
            return this.events.isEmpty();
        }
        return true;
    }

    synchronized void remove(Object object) {
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "-> remove(" + object + ")");
        }
        if (this.events != null) {
            this.events.remove(object);
            if (3 <= Trace.LEVEL) {
                this.doDebug("events are now: ");
            }
        }
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "<- remove(...)");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        SurveillanceEventList surveillanceEventList = this;
        synchronized (surveillanceEventList) {
            return this.toStringEvents();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String toStringEvents() {
        StringBuffer stringBuffer = new StringBuffer();
        Map.Entry entry = null;
        Date date = null;
        Vector vector = null;
        SurveillanceEvent surveillanceEvent = null;
        SurveillanceEventList surveillanceEventList = this;
        synchronized (surveillanceEventList) {
            stringBuffer.append("(events = (");
            Iterator iterator = this.events.entrySet().iterator();
            while (iterator.hasNext()) {
                entry = iterator.next();
                date = (Date)entry.getKey();
                stringBuffer.append("(" + date + ", (");
                vector = (Vector)entry.getValue();
                Iterator iterator2 = vector.iterator();
                while (iterator2.hasNext()) {
                    surveillanceEvent = (SurveillanceEvent)iterator2.next();
                    stringBuffer.append(surveillanceEvent + ",");
                }
                stringBuffer.append("))");
            }
            stringBuffer.append("))");
            return stringBuffer.toString();
        }
    }

    void doDebug(String string) {
        String string2 = null;
        int n = 0;
        Trace.trace(TRACE_MASKD, string);
        string2 = this.toString();
        n = string2.length();
        for (int i = 0; i < string2.length(); i += 80) {
            if (i + 80 >= n) {
                Trace.trace(TRACE_MASKD, string2.substring(i, n));
                return;
            }
            Trace.trace(TRACE_MASKD, string2.substring(i, i + 80));
        }
    }

    synchronized void updateNotRunning(String string, String string2, String string3) {
        SurveillanceEvent surveillanceEvent = null;
        Vector vector = null;
        Map.Entry entry = null;
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "-> updateNotRunning(" + string + ", " + string2 + ", " + string3 + ")");
        }
        Iterator iterator = this.events.entrySet().iterator();
        while (iterator.hasNext()) {
            entry = iterator.next();
            vector = (Vector)entry.getValue();
            Iterator iterator2 = vector.iterator();
            while (iterator2.hasNext()) {
                UnsignedInt8 unsignedInt8;
                surveillanceEvent = (SurveillanceEvent)iterator2.next();
                if (!surveillanceEvent.getPartitionId().equals(string3) || !surveillanceEvent.getCECMTM().equals(string) || !surveillanceEvent.getCECMS().equals(string2) || !surveillanceEvent.getType().equals(SurveillanceEventType.DISCONNECT) && !surveillanceEvent.getType().equals(SurveillanceEventType.NOT_YET_CONNECTED) || (unsignedInt8 = surveillanceEvent.getPartitionCIMState()) == null || unsignedInt8.intValue() != 2) continue;
                surveillanceEvent.setBecameNotRunning();
                if (3 > Trace.LEVEL) continue;
                Trace.trace(TRACE_MASKD, "event now changed because partition not running anymore : " + surveillanceEvent);
            }
        }
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "<- updateNotRunning(...)");
        }
    }
}

